﻿//////////////////////////////////////////////
// DataAllocator.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkInputs
{
	class KeyboardDevice ;
	class MouseDevice ;
	class System ;
}

/// Class ------------------------------------

namespace nkInputs
{
	class DataAllocator
	{
		public :

			// Constructor, destructor
			DataAllocator (System* system) noexcept ;
			virtual ~DataAllocator () ;

			// Allocations
			virtual KeyboardDevice* allocateKeyboardDevice () const = 0 ;
			virtual MouseDevice* allocateMouseDevice () const = 0 ;

		protected :

			System* _system ;
	} ;
}